#include <bits/stdc++.h>
using namespace std;

int w, h;
int k = 0;

void solve(queue<int> qx, queue<int> qy, vector< vector<char> > space, vector< vector<bool> > visited) {
    int nodesHere = 1;
    int nodesNext = 0;

    while (!qx.empty()) {
        int x = qx.front();
        int y = qy.front();

        qx.pop();
        qy.pop();

        for (int i = -1; i <= 1; i++) {
            for (int j = -1; j <= 1; j++) {
                int xx = x + i;
                int yy = y + j;

                if (xx < 0 || xx == w || yy < 0 || yy == h)
                    continue;
                if (i == 0 && j == 0)
                    continue;
                if (visited[yy][xx])
                    continue;
                if (space[yy][xx] == '#')
                    continue;

                qx.push(xx);
                qy.push(yy);
                visited[yy][xx] = true;
                nodesNext++;
            }
        }

        if (x == w - 1 && y == h - 1) {
            return;
        }

        nodesHere--;
        if (nodesHere == 0) {
            k++;
            nodesHere = nodesNext;
            nodesNext = 0;
        }
    }

    k = -1;
}

int main() {
    ios_base::sync_with_stdio(false);

    // INPUT

    cin >> h >> w;

    vector< vector<char> > space;
    vector< vector<bool> > visited;

    for (int y = 0; y < h; y++) {
        vector<char> v;
        for (int x = 0; x < w; x++) {
            char c;
            cin >> c;
            v.push_back(c);
        }
        space.push_back(v);
    }

    // ALGO INIT

    for (int y = 0; y < h; y++) {
        vector<bool> v;
        for (int x = 0; x < w; x++) {
            v.push_back(false);
        }
        visited.push_back(v);
    }

    queue<int> qx;
    queue<int> qy;

    qx.push(0);
    qy.push(0);

    // ALGO

    solve(qx, qy, space, visited);

    // output

    cout << k;
    return 0;
}